//		DaveUtils.c

#ifndef _H_DaveUtils
#define _H_DaveUtils

#include "QDOffscreen.h"

#ifndef u_char
	typedef unsigned char u_char;
#endif

//	keys used in check_key_down
#define		shift_key		0x00000001
#define 	caps_lock		0x00000002
#define		option_key		0x00000004
#define 	control_key		0x00000008
#define		command_key		0x00008000

//	ascii codes

#define		ENTER_KEY			0X03
#define		DELETE_KEY			0x08
#define		FORWARD_DEL_KEY		0x7F
#define		TAB_KEY				0x09
#define		RETURN_KEY			0X0D
#define		ESC_CLEAR_KEY		0x1B
#define		LEFT_KEY			0x1C
#define		RIGHT_KEY			0x1D
#define		UP_KEY				0x1E
#define		DOWN_KEY			0x1F

#define		STRUCT_COPY(source, dest, field)	\
	(dest).field = (source).field

#define FRAME_RECT_OR_OVAL(oval, r)	\
			if (oval) FrameOval(&r); else FrameRect(&r)

#define		GetControlMenu(x)	**(MenuHandle **)((**x).contrlData)

#define	NopPoint(point)			*(long *)&(point) = 0
#define	EqualPoint(p1, p2)		(*(long *)&(p1) == *(long *)&p2)
#define	DeltaPoint1(p1, p2, returnPoint)					\
	do {													\
		*(long *)(returnPoint) = DeltaPoint((p1), (p2));	\
	} while (0)

#define	NopRect(rect)			\
	NopPoint(topLeft(rect));	\
	NopPoint(botRight(rect))

typedef	struct Translate_struct {
	double	from;			//	>>
	double	from_min;		//	>>
	double	from_max;		//	>>
	
	double	to;				//	<<	only one passed back!
	double	to_min;			//	>>
	double	to_max;			//	>>
} TranslateRec, *TranslatePtr;

// note: changed chr from short to long for alignment purposes 9/29/95 -dps
typedef struct _KeyCmd {
	short	modifiers;	// on or off
	short	mask;		// which modifier keys are optional, zero requires exact match
	long	chr;		// character hit (lower case), use non-positives for key-code
	long	cmd;		// resultant command
} KeyCmd;

#define Mod_NONE	0
#define Mod_c		controlKey
#define Mod_S		shiftKey
#define Mod_C		cmdKey
#define Mod_O		optionKey
#define Mod_SO		(Mod_S | Mod_O)
#define Mod_CS		(cmdKey | shiftKey)
#define Mod_CSO		(cmdKey | shiftKey | optionKey)
#define Mod_CSOc	(cmdKey | shiftKey | optionKey | controlKey)
#define Mod_CO		(cmdKey | optionKey)
#define Mod_Cc		(cmdKey | controlKey)
#define Mod_CSc		(cmdKey | shiftKey | controlKey)
#define Mod_Sc		(shiftKey | controlKey)
#define Mod_SOc		(shiftKey | optionKey | controlKey)

enum {			// key codes
	KeyA = 0,
	KeyS,
	KeyD,
	KeyF,
	KeyH,
	KeyG,
	KeyZ,
	KeyX,
	KeyC,
	KeyV,
	KeyQ = 0xc,
	KeyW,
	KeyE,
	KeyR,
	KeyY,
	KeyT,
	Key1,
	Key2,
	Key3,
	Key4,
	Key6,
	Key5,
	KeyEquals,
	Key9,
	Key7,
	KeyMinus,
	Key8,
	Key0,
	KeyRightBracket,
	KeyO,
	KeyU,
	KeyLeftBracket,
	KeyI,
	KeyP,
	KeyReturn,
	KeyL,
	KeyJ,
	KeyQuote,
	KeyK,
	KeySemi,
	KeyBackSlash,
	KeyComma,
	KeySlash,
	KeyN,
	KeyM,
	KeyPeriod,
	KeyTab,
	KeySpace,
	KeyBackQuote,
	KeyDelete,
	
	KeyEsc = 0x35,
	
	KeyEnter = 0x4c, 
	KeyPadPlus = 0x45,
	KeyPadMinus = 0x4e,
	KeyPadAsterisk = 0x43,
	KeyPadSlash = 0x4b,
	KeyPadEquals = 0x51,
	KeyPadClear = 0x47,
	KeyPadPeriod = 0x41,
	KeyPad0 = 0x52,
	KeyPad1,
	KeyPad2,
	KeyPad3,
	KeyPad4,
	KeyPad5,
	KeyPad6,
	KeyPad7,
	KeyPad8 = 0x5b,
	KeyPad9,
	
	KeyHELP = 0x72,			// changed caps to avoid collision w/Constants.h
	KeyFwdDel = 0x75,
	KeyHOME = 0x73,
	KeyEND = 0x77,
	KeyPageUP = 0x74,
	KeyPageDOWN = 0x79,
	
	KeyLeftArrow = 0x7b,
	KeyRightArrow,
	KeyDownArrow,
	KeyUpArrow
};

#define		C_MENU_BLANK	" "
#define		P_MENU_BLANK	"\p"C_MENU_BLANK

#define		C_MENU_SEPARATOR	"(-"
#define		P_MENU_SEPARATOR	"\p"C_MENU_SEPARATOR

Rect		PointToRect(Point thePoint, short size, short extra);

void		StringToTextEdit(char *string, TEHandle te);
char		*TextEditToString(TEHandle te, char *string);

short		IUCompCString(char *aStr, char *bStr);

int			check_key_down(long key_mask);

long		RoundToNearestMult(long x, unsigned long m);

			// note: for localizable keytranslation, see NewTranslateKeyToCommand in EggUtils.h
long		TranslateKeyToCommand(const KeyCmd *kc, const register EventRecord *evt);

void		LocalRectToGlobal(Rect *theRect);
void		GlobalRectToLocal(Rect *theRect);

typedef		Boolean	(*MarqueeWillAutoScrollCB)(Point thePoint, Rect *frameRect, void *data);
typedef		Boolean	(*MarqueeDoAutoScrollCB)(Point thePoint, Rect *frameRect, void *data);

Boolean		MouseStateChanged(
	Point	startPoint, 
	long	timeOutTicks, 
	short	pixDelta, 
	Boolean	*moved, 
	Boolean	*buttonUp
);

Boolean		TrackMouse1(	Rect *theRectPtr,
							void (*HilightProc)(Rect *theRect, void *data, Boolean in, Boolean Last),
							void (*TrackingProc)(void *data),
							void *data);
							
void		InvertHilite(Rect *theRect, void *data, Boolean in, Boolean last);

StringPtr	CopyC2P(const char *see_string, unsigned char *pee_string);
char *		CopyP2C(const unsigned char *pee_string, char *see_string);

void		DrawOnlyGrowIcon(WindowPtr theWindow);

void		PlotIconMaskHandle(Handle iconHandle, short index, short iconSize, short hPos, short vPos);
void		PlotIconHandle(Handle iconHandle, short listID, short iconSize, short hPos, short vPos);

void		PlotSIcon(short resID, short listID, short hPos, short vPos);
void		PlotSIconHandle(Handle iconHandle, short listID, short hPos, short vPos);
void		PlotSIconMaskHandle(Handle iconHandle, short index, short hPos, short vPos);

void		PlotMIconHandle(Handle iconHandle, short listID, short hPos, short vPos);

void		HiliteRect(Rect *theRect);
void		EraseInsetRect(Rect r);

char		*FormatBytes(long bytes, char *buffer);

void		SetFPS(short fps);
short		GetFPS(void);

void		RemoveTrailingNumber(char *name);

void		SetFixedFPS(Fixed fps);
Fixed		GetFixedFPS(void);

void		SetUseTimeCode(Boolean tc);
Boolean		GetUseTimeCode(void);

void		BlitPict(PicHandle	pictHandle, int  hOffset, int  vOffset);

void		DrawCString(const char *str);
short		DrawHotText(short x, short y, short max_width, const char *str);
void		GetHotTextRect(short x, short y, short string_width, Rect *r);

#define		kHotTextSubscript	6

typedef enum {
	kTextAlignLeft,
	kTextAlignCenter,
	kTextAlignRight
} TextAlignmentType;

void		ClearMenu(MenuHandle theMenu);
void		UnmarkMenuGroup(MenuHandle theMenu, int firstItem, int lastItem);

short		DrawTextNF(short x, short y, short max_width, const char *str,
						TextAlignmentType align);


void		DrawCheck(short checked, Rect *theRect);
void		UncheckToCheck(Rect *frameRect, void *data, Boolean in, Boolean last);
void		CheckToUncheck(Rect *frameRect, void *data, Boolean in, Boolean last);
Boolean		TrackCheck(
				Rect	*theRect, 
				Boolean	checked, 
				void	(*TrackingProc)(void *data),
				void	*data);

void		BicRect(Rect *theRect);
GWorldPtr	GetPictResOffscreen(short pictResID, short depth);

void		ConcatNumToString(void *srcStr1, long theNum, void *dstString);
void		Concat(const void *srcStr1, const void *srcStr2, void *dstString);
void		CopyString(const void *srcString, void *dstString);
void		ShrinkCString(char *theString, short space_for_string);
void		ShrinkString(u_char *theString, short space_for_string);

void		RadioButtonItem(MenuHandle theMenu, int firstItem, int lastItem, int buttonItem, char mark);
void		CopyMenu(MenuHandle dest_menu, MenuHandle src_menu);

short		mandelbrot_iterate(double x, double y, short max_iterations);

void		Translate(TranslatePtr trans);
double		LERP(double to_min, double to_max, double from, double from_min, double from_max);
#define		LERP(to_min, to_max, from, from_min, from_max)	\
	((double)(to_min) + ((double)((to_max) - (to_min)) * ((double)((from) - (from_min)) / (double)((from_max) - (from_min)))))

void		DashItems(MenuHandle theMenu, int firstItem, int lastItem, long itemFlags);
long		Gcd(long u, long v);

long		DoFixedSizePopMenu(MenuHandle theMenuH, Point loc, short width, short old_item);
long		DoFlexSizePopMenu(short menuID, MenuHandle theMenuH, Point loc, short width0, short old_item, short font, short size, short style);


extern	ModalFilterUPP	G_AlertFilterUPP;
	
#define	ALERT_FILTER	G_AlertFilterUPP


//Err			OpenExternalDocument(FSSpecPtr theDoc);


typedef struct {
	long	key, value;
} LongLookup;

enum {
	FEE_LongLookup_FROM_DLG, FEE_LongLookup_TO_DLG
};
typedef	long	FEE_LongLookupDirection;

#define		FEE_LONG_LOOKUP_SETUP(table, pointer, numitems)		\
	do {														\
		pointer		= table;									\
		numitems	= sizeof(table)/sizeof(LongLookup);			\
	} while (0)

#define LONG_LOOKUP(key, table)				\
							DoLongLookup(key, sizeof(table)/sizeof(LongLookup), table)

#define LONG_LOOKUP_BY_VALUE(value, table)	\
							DoReverseLongLookup(value, sizeof(table)/sizeof(LongLookup), table)


long	DoLongLookup(long key, short items, const LongLookup *table);
long	DoReverseLongLookup(long value, short items, const LongLookup *table);

typedef	struct {
	short	oldFont;
	short	oldSize;
	Style	oldStyle;
	short	oldMode;
} NIM_FontState;

Rect	GetGlobalWindowPos(GrafPtr thePort);

void	GetFontState(NIM_FontState *fontState);
void	SetFontState(NIM_FontState *fontState);

void	PaintDiamond(const Rect *r);
char	*Strrstr(const char *str, const char *substr);
void		HiliteGrayFrameRect(Rect *theRect);
void		InvertGrayFrameRect(Rect *theRect);

void		AppendLiteralPMenu(MenuHandle theMenu, u_char *pstring);
void		AppendLiteralCMenu(MenuHandle theMenu, char *cstring);
short		TruncateShort(long *value);
char		*RemoveBrackets(char *string);

float		DB2Percent(float db);
char		*FormatPercentage(float p, char *buf);
	

#endif
